<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CoveoDiagnosticPackage.aspx.cs" Inherits="Coveo.SearchProvider.Applications.CoveoDiagnosticPackage" EnableSessionState="false" %>
<%-- NOTE: When making changes to this file, verify if another copy exists for a specific Sitecore version. --%>

<!DOCTYPE html>
<html>
<head>
    <title>Coveo for Sitecore Diagnostic Package</title>
    <style>
        @import url(http://fonts.googleapis.com/css?family=Arimo);

        body {
            font-family: Arimo;
            font-weight: normal;
        }

        .main-div {
            text-align: center;
            width: 100%;
        }

        #credentials {
            text-align: center;
            box-shadow: black 2px 2px 10px;
            border-radius: 5px;
            width: 350px;
        }

        #credentials > .header {
            padding: 10px;
            border-bottom: 1px solid black;
            margin-bottom: 5px;
        }

        #credentials > .message {
            padding: 10px;
        }

        #credentials > div.form-value {
            margin-top: 5px;
            text-align: center;
            padding-bottom: 10px;
        }

        #credentials > div.form-value > label {
            width: 150px;
        }

        #credentials > div > input {
            width: 150px;
            border-radius: 6px;
        }

        #credentials > #ErrorMessage {
            color: red;
        }

        #credentials > .submit-button {
            width: 90%;
            margin: 10px;
            padding: 10px;
        }
    </style>
</head>
<body>
    <div class="main-div">
        <form id="credentials" runat="server" method="post">
            <div class="header">
                Generate the Coveo diagnostic package
            </div>
            <div class="message">
                You need to be logged in to create a Coveo diagnostic package.
            </div>
            <div class="form-value">
                <label for="username">Username</label>
                <input id="username" name="username"/>
            </div>
            <div class="form-value">
                <label for="password">Password</label>
                <input id="password" type="password" name="password"/>
            </div>
            <asp:Label runat="server" id="ErrorMessage"/>
            <asp:Button runat="server" CssClass="submit-button" Text="Generate Package" OnClick="OnSubmitClick"/>
        </form>
        <div class="logo-footer"></div>
    </div>
</body>
</html>